Rem -- 
Rem -- Run this function when the macros are applied.
Rem -- 
Sub OnMacrosApplied
	Dim fso, output, filename, extension, foldername
	
	Rem -- Create a file system object for file path helper functions
	Set fso = CreateObject("Scripting.FilesystemObject")
	
	Rem -- Get the current output value
	output = context("Config")("output")
	
	Rem -- Get the file path parts
	filename = fso.GetBaseName(output)
	foldername = fso.GetParentFolderName(output)
	extension = fso.GetExtensionName(output)
	
	Rem -- Reverse the file name
	filename = StrReverse(filename)
	
	Rem -- Assemble the file path again
	output = foldername & "\" & filename & "." & extension
	
	Rem -- Set the new file path in the output
	context("Config")("output") = output
	
	Rem -- Make sure the configuration isn't reloaded because of an option set selection.
	context("Config")("rememberlastoptionset") = "no"	
	
	Rem -- Clean up
	Set fso = Nothing
End Sub